<!DOCTYPE HTML>
<?PHP
	require 'functions.php';
	checkLogin();
	$db_link = connect();

    $rep_year = date("Y",time());
	$rep_month = date("m",time());

	//Make array for exporting data
	$_SESSION['rep_export'] = array();
	$_SESSION['rep_exp_title'] = $rep_year.'-'.$rep_month.'_loans-result';

	//Select from LOANS depending on Search or not Search
	if (isset($_POST['loan_no'])){
		$loan_search = sanitize($db_link, $_POST['loan_no']);
		$sql_loansearch = "SELECT * FROM loans LEFT JOIN loanstatus ON loans.loanstatus_id = loanstatus.loanstatus_id LEFT JOIN customer ON loans.cust_id = customer.cust_id WHERE loan_no LIKE '%$loan_search%'";
		$query_loansearch = mysqli_query($db_link, $sql_loansearch);
		checkSQL($db_link, $query_loansearch);
	}
	elseif (isset($_POST['loan_status'])){
		$loan_search = sanitize($db_link, $_POST['loan_status']);
		$sql_loansearch = "SELECT * FROM loans LEFT JOIN loanstatus ON loans.loanstatus_id = loanstatus.loanstatus_id LEFT JOIN customer ON loans.cust_id = customer.cust_id WHERE loans.loanstatus_id = '$loan_search'";
		$query_loansearch = mysqli_query($db_link, $sql_loansearch);
		checkSQL($db_link, $query_loansearch);
	}
	else header('Location: start.php');
?>

<html>
	<?PHP includeHead('Loans Search Result',1) ?>
	<body>

		<!-- MENU -->
		<?PHP includeMenu(3); ?>
		<div id="menu_main"> <!--
			<a href="loans_search.php" id="item_selected">Search</a>
			<a href="loans_act.php">Active Loans</a>
			<a href="loans_pend.php">Pending Loans</a> -->
            <a href="loans_search.php">Back</a>
		</div>
        
        <!-- tables pagination -->
        <link rel="stylesheet" href="css/paginationTable.css">
        
        <link href="http://maxcdn.bootstrapcdn.com/bootstrap/3.2.0/css/bootstrap.min.css" rel="stylesheet">   
        <script src="http://ajax.googleapis.com/ajax/libs/jquery/1.7.1/jquery.min.js"></script>
        <link rel="stylesheet" href="http://cdn.datatables.net/1.10.2/css/jquery.dataTables.min.css">
        <script type="text/javascript" src="http://cdn.datatables.net/1.10.2/js/jquery.dataTables.min.js"></script>
        <script type="text/javascript" src="http://maxcdn.bootstrapcdn.com/bootstrap/3.2.0/js/bootstrap.min.js"></script>
        
        
    <div class="container2">
        
    <h3 class="actCusttHeading">Loan Search Results</h3>
    <div class="exportCdata">
    <form class="export" action="rep_export.php" method="post">
        <!-- Export Button -->	
        <input type="submit" style="background-color: #4682B4 !important; color: #ffffff;" name="export_rep" value="Export" />	
    </form>
    </div>
    <!-- TABLE: Loan Search Result -->
    <table id="myTable" class="table table-striped table-bordered table-responsive table-hover" >
		<thead>
			<tr> 
            <th scope="col">Loan No</th>
			<th scope="col">Customer</th>
            <th scope="col">Status</th>
			<th scope="col">Period</th>
			<th scope="col">Principal</th>
			<th scope="col">Interest</th>
			<th scope="col">Applied for on</th> 
            <th scope="col">Issued</th>
			</tr>                
		</thead>
        <tbody> 
        <?php
           
			$count = 0;
			while ($row_loansearch = mysqli_fetch_assoc($query_loansearch)){ ?>
		<tr>  
            <td data-label="Loan No">
                <a href="loan.php?lid=<?php echo $row_loansearch['loan_id']; ?>"><?php echo $row_loansearch['loan_no']; ?></a>
            </td>
            
			<td data-label="Customer">
                <?php  echo $row_loansearch['cust_name']; ?> 
                <a href="customer.php?cust=<?php echo $row_loansearch['cust_id'];?>">
                    (<?php echo $row_loansearch['cust_no'];?>)
                </a>
            </td>
            <td data-label="Status">
                <?php echo  $row_loansearch['loanstatus_status']; ?>
            </td>
           
			<td data-label="Period"><?php echo $row_loansearch['loan_period']; ?></td>
            
			<td data-label="Principal">
                <?php echo number_format($row_loansearch['loan_principal']).' '.$_SESSION['set_cur']; ?>
            </td>
			<td data-label="Interest">
                <?php echo number_format(($row_loansearch['loan_repaytotal'] - $row_loansearch['loan_principal'])).' '.$_SESSION['set_cur']; ?>
            </td>
            
            <td data-label="Applied for On"><?php echo date("d.m.Y",$row_loansearch['loan_date']); ?></td>
            
            <td data-label="Issued"><?php
				if ($row_loansearch['loan_dateout'] == 0) echo "No";
				else echo date("d.m.Y", $row_loansearch['loan_dateout']); ?>
            </td>
		</tr> 
        <?php                                                    
            if(empty($row_loansearch['loan_principalapproved'])){
                $lPrincipalExport = $row_loansearch['loan_principal'];
            }
            else{ $lPrincipalExport = $row_loansearch['loan_principalapproved']; }
                                                                            
            $lInterestExport = $row_loansearch['loan_repaytotal'] - $lPrincipalExport;
            
            if ($row_loansearch['loan_dateout'] == 0) { $lIssuedExport = "No"; }
				else { $lIssuedExport = date("d.m.Y", $row_loansearch['loan_dateout']); }
                                                                            
            /* Export Loan Data array */                                           
            array_push($_SESSION['rep_export'], array("Loan No." => $row_loansearch['loan_no'], "Customer" => $row_loansearch['cust_name'], "Status" => $row_loansearch['loanstatus_status'],"Loan Period" => $row_loansearch['loan_period'], "Principal" => $lPrincipalExport, "Interest" => $lInterestExport, "Applied for On" => date("d.m.Y",$row_loansearch['loan_date']), "Issued" => $lIssuedExport ));
                                                                        
                                                                  
            $count++;   }	?>
        </tbody>  
    </table>
        <hr class="new1" style="border-top: 1px solid #FB788E;">		
    </div>

    <?php include 'views/partial/footer.php'; ?>
    <script src="js/atcMFmainJS.js"></script>
	</body>
<script>
$(document).ready(function(){
    $('#myTable').dataTable();
});
</script>
</html>
